package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Coyot_FR_door extends FrontDoor
{
	public Coyot_FR_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Coyot front right door";

		value = 250;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.coyot:0x000000E7r, "FR window", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E7r, "FR window", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000F4r, "R mirror", actcolor, optical, power );
		} else
		{
			float part_random = random();
			if ( part_random >= 0.66667 ) addPart( cars.cat_01.coyot:0x000000F2r, "R mirror 3", actcolor, optical, power ); else
			if ( part_random >= 0.33333 ) addPart( cars.cat_01.coyot:0x000000F5r, "R mirror 2", actcolor, optical, power ); else
			addPart( cars.cat_01.coyot:0x000000F4r, "R mirror", actcolor, optical, power );
		}
	}
}
